import { IncomingMessage } from 'http';
import { STAFF_TOKEN_COOKIE_NAME } from '@/configs';
import roles from '@/data/role';
import { authenticationStaff } from '@/services/auth';

export const authentication = async (
    req: IncomingMessage & {
        cookies: Partial<{
            [key: string]: string;
        }>;
    },
    permission?: (typeof roles)[number],
) => {
    const token = req.cookies[STAFF_TOKEN_COOKIE_NAME];

    if (!token) {
        throw new Error('token not found');
    }

    const response = await authenticationStaff({
        token: token ? token : '',
        permission: permission ? permission : '',
    });

    const result = response.data;

    return result;
};
