import { BaseBook, MedicalCertificate, Member, PaginationResponse, PaginationState, Staff } from '.';

// Study Group
export enum StudyGroupStatus {
    DRAFT = 'DRAFT',
    GENERATED = 'GENERATED',
    ONGOING = 'ONGOING',
    COMPLETED = 'COMPLETED',
}

export interface StudyGroup extends PaginationState {
    id: string;
    bookId: string;
    name: string;
    status: StudyGroupStatus;
    startDate: string;
    endDate: string;
    description: string;
    createdAt: string;
    updatedAt: string;
    book: BaseBook;
    studyGroupTask: StudyGroupTask[];
    studyGroupMember: StudyGroupMember[];
    _count: {
        studyGroupMembers: number;
    };
}

export interface Replies {
    id: string;
    studyGroupTaskId: string;
    memberId: string;
    staffId: string;
    comment: string;
    prePlanned: boolean;
    prePlannedDate: string;
    commentDate: string;
    likeCount: number;
    parent_id: string;
    Children: Replies[];
    createdAt: string;
    updatedAt: string;
    studyGroupTask: StudyGroupTask;
    member: Member;
    staff: Staff;
}

export interface CommentLike {
    id: string;
    studyGroupTaskId: string;
    studyGroupTaskCommentId: string;
    staffId: string;
}

export interface CreateStudyGroup {
    name: string;
    bookId: string;
    groupPeriod: string[];
}

export interface EditStudyGroup {
    name: string;
    groupPeriod: string[];
    description: string;
}

// Study Group Member
export interface StudyGroupMember {
    id?: string;
    memberId: string;
    studyGroupId: string;
    createdAt: string;
    updatedAt: string;
    studyGroup: StudyGroup;
    member: Member;
    memberCount: number;
    studyGroupMembers: MemberData[];
}

export interface MemberData {
    id: string;
    fullName: string;
    preferredName: string;
    createdAt: string;
    phoneNumber: string;
    medicalCertificate: MedicalCertificate[];
}

export interface StudyGroupMembers {
    id: string;
    fullName: string;
    preferredName: string;
    phoneNumber: string;
    email: string;
    createdAt: string;
}

// Study Group Task
export interface StudyGroupTask {
    id: string;
    studyGroupId: string;
    description: string;
    taskDate: string;
    status: boolean;
    createdAt: string;
    updatedAt: string;
    totalAmount: number;
    studyGroup: StudyGroup;
    studyGroupTaskComment: StudyGroupTaskComment[];
    penalties: Penalty[];
    medicalCertificate: MedicalCertificate[];
}

export interface StudyGroupTaskComment {
    id: string;
    studyGroupTaskId: string;
    memberId: string;
    staffId: string;
    comment: string;
    prePlanned: boolean;
    prePlannedDate: string;
    commentDate: string;
    likeCount: number;
    parent_id: string;
    createdAt: string;
    updatedAt: string;
    studyGroupTask: StudyGroupTask;
    member: Member;
    replies: Replies[];
    staff: Staff;
    Children: StudyGroupTaskComment[];
}

export interface UpdateStudyGroupTaskDescription {
    description: string;
}

export interface UpdateStudyGroupTaskPeriod {
    taskPeriod: string[];
}

// Penalty
export interface Penalty {
    id: string;
    memberId: string;
    studyGroupTaskId: string;
    amount: number;
    createdAt: string;
    updatedAt: string;
    member: Member;
    studyGroupTask: StudyGroupTask;
    totalAmount: number;
}

// Create
export interface CreateStudyGroup {
    name: string;
    bookId: string;
    groupPeriod: string[];
}

// export interface StudyGroupQuery {
//     selectGroupName: string;
//     enterGroupName: string;
//     groupPeriod: string;
// }

// export interface StudyGroupBookQuery {
//     id: string;
//     name: string;
// }

// export interface CreateStudyGroupTask {
//     name: string;
//     description: string;
//     taskPeriod: string[];
// }

// export interface StudyGroupTaskData {
//     id: string;
//     name: string;
//     description: string;
//     startDate: string;
//     endDate: string;
//     status: boolean;
//     penalties: number;
//     studyGroupSubTask: StudyGroupSubTaskData[];
// }

// export interface StudyGroupSubTaskData {
//     _count: any;
//     id: string;
//     name: string;
//     date: string;
//     penalties: {
//         id: string;
//         amount: number;
//     };
// }

// export interface StudyGroupSubTaskCommentData {
//     id: string;
//     comment: string;
//     createdAt: string;
//     memberId: string;
//     member: {
//         id: string;
//         fullName: string;
//     };
//     studyGroupSubTask: {
//         id: string;
//         name: string;
//     };
// }

// export interface PenaltyData {
//     id: string;
//     amount: number;
//     memberName: string;
//     studyGroupSubTaskPenalty: {
//         penalties: {
//             member: {
//                 id: string;
//                 fullName: string;
//             };
//         };
//     };
// }

// export interface StudyGroupSubTask {
//     id: string;
//     date: string;
//     penalties: {
//         amount: number;
//     };
//     _count: {
//         studyGroupTaskComment: number;
//     };
//     studyGroupTaskComment: StudyGroupMember;
// }

// export interface StudyGroupTaskWithSubTasks {
//     studyGroupTaskId: string;
//     name: string;
//     description: string;
//     startDate: string;
//     endDate: string;
//     status: boolean;
//     subTasks: {
//         id: string;
//         date: string;
//         commentCount: number;
//         penaltyAmount: number;
//     }[];
// }

export interface PenaltySummary {
    amount: number;
    member: Pick<Member, 'id' | 'fullName' | 'preferredName'>;
    studyGroupTask: StudyGroupTask;
}

export type SubTasksPenaltySummary = PenaltySummary;
export type StudyGroupPenaltySummary = PenaltySummary;
