import { Member } from './member';
import { StudyGroupTask } from './study-group';

export enum MedicalCertificateStatus {
    PENDING = 'PENDING',
    APPROVED = 'APPROVED',
    REJECTED = 'REJECTED',
}

export interface MedicalCertificate {
    id: string;
    memberId: string;
    member: Member;
    studyGroupTaskId: string;
    studyGroupTask: StudyGroupTask;
    status: MedicalCertificateStatus;
    applyDate: string;
    createdAt: string;
    updatedAt: string;
    media: {
        mediaId: string;
        media: {
            key: string;
            name: string;
        };
    }[];
}

export type UploadMedicalCertificatePayload = {
    medias: { mediaId: string }[];
};
