import axiosInstance from '@/configs/service';
import { Staff } from '@/types';

export const getMyProfile = () => {
    return axiosInstance.get<Staff>('/staff/my-profile');
};

export const updateMyProfile = (fullName: string) => {
    return axiosInstance.put<Staff>('/staff/my-profile', { fullName });
};

export const updateMyEmail = (email: string) => {
    return axiosInstance.put<Staff>('/staff/my-profile/email', { email });
};

export const updateMyPassword = (password: string) => {
    return axiosInstance.put<Staff>('/staff/my-profile/password', { password });
};

export const updateMyPhone = (phone: string) => {
    return axiosInstance.put<Staff>('/staff/my-profile/phone', { phone });
};
