import axiosInstance, { uploadInstance } from '@/configs/service';
import {
    BookTokenDetails,
    BookTokenRequestParams,
    BookTokenSubscriptionList,
    MediaFormValue,
    MediaResponse,
    PaginationParams,
    PaginationResponse,
    SortOrder,
    UpdateBookTokenDetails,
} from '@/types';
import { mediaUrlGenerator } from '@/utils';

export const bookTokenKeys = {
    pagination: (pagination: PaginationParams = { page: 1, pageSize: 10, sortField: 'createdAt', sortOrder: SortOrder.DESC }) => [
        'book-token-subscription',
        'pagination',
        pagination,
    ],
    id: (id: string) => ['book-token-subscription', id],
};

export const getBookTokenSubscriptionList = (query: PaginationParams) => {
    return axiosInstance.get<PaginationResponse<BookTokenSubscriptionList>>('/staff/book-token', { params: query });
};

export const getExportBookTokenSubscriptionList = (query: BookTokenRequestParams) => {
    return axiosInstance.get('/staff/book-token/export', { params: query });
};

export const getBookTokenSubscriptionById = (id: string) => {
    return axiosInstance.get<BookTokenDetails>(`/staff/book-token/${id}`);
};

export const uploadProofMedia = async (url: string, option: any) => {
    const formData = new FormData();
    formData.append('file', option.file);

    try {
        const response = await uploadInstance.post<MediaResponse>(url, formData);

        option.onSuccess({
            uid: response.data.id,
            name: response.data.name,
            url: mediaUrlGenerator(response.data.key),
            status: 'done',
        } as MediaFormValue);
    } catch (error) {
        option.onError(error);
    }
};

export const updateBookTokenById = (id: string, body: UpdateBookTokenDetails) => {
    return axiosInstance.put<UpdateBookTokenDetails>(`/staff/book-token/${id}`, body);
};

export const deleteBookTokenRequest = (id: string) => {
    return axiosInstance.delete(`/staff/book-token/${id}`);
};
