import axiosInstance, { uploadInstance } from '@/configs/service';
import { MediaFormValue, MediaResponse, PaginationParams, PaginationResponse } from '@/types';
import { BookOrderDetails, BookOrderList, UpdateBookOrderDetails } from '@/types/book-order';
import { mediaUrlGenerator } from '@/utils';

export const getBookOrderList = (query: PaginationParams) => {
    return axiosInstance.get<PaginationResponse<BookOrderList>>('/staff/book-order', { params: query });
};

export const getBookOrderById = (bookOrderId: string) => {
    return axiosInstance.get<BookOrderDetails>(`/staff/book-order/${bookOrderId}`);
};

export const getAllBookOrder = () => {
    return axiosInstance.get<BookOrderList>('/staff/book-order/all');
};

export const updateBookOrderById = (bookOrderId: string, body: UpdateBookOrderDetails) => {
    return axiosInstance.put(`/staff/book-order/${bookOrderId}`, body);
};

export const deleteBookOrderById = (bookOrderId: string) => {
    return axiosInstance.delete(`/staff/book-order/${bookOrderId}`);
};

export const uploadBookOrderMedia = async (url: string, option: any) => {
    const formData = new FormData();
    formData.append('file', option.file);

    try {
        const response = await uploadInstance.post<MediaResponse>(url, formData);

        option.onSuccess({
            uid: response.data.id,
            name: response.data.name,
            url: mediaUrlGenerator(response.data.key),
            status: 'done',
        } as MediaFormValue);
    } catch (error) {
        option.onError(error);
    }
};
