import { EllipsisOutlined } from '@ant-design/icons';
import { Button, Dropdown, MenuProps } from 'antd';

interface ActionDropdownProps {
    items: MenuProps['items'];
}

const ActionDropdown: React.FC<ActionDropdownProps> = ({ items }) => {
    return (
        <Dropdown
            menu={{
                items,
            }}
            trigger={['click']}
            placement="bottomRight"
            overlayStyle={{ minWidth: '150px' }}
        >
            <Button icon={<EllipsisOutlined />} />
        </Dropdown>
    );
};

export default ActionDropdown;
