import React, { useState } from 'react';
import { useTranslation } from 'next-i18next';
import { FilterOutlined, SearchOutlined } from '@ant-design/icons';
import { Button, Col, Form, Input, Modal, Row } from 'antd';
import { FormInstance } from 'antd/es/form/Form';

interface FilterAttributes {
    filterStudyGroupMemberForm: FormInstance;
    onReset: () => void;
    onSearch: () => void;
    loading: boolean;
}

const FilterDrawer: React.FC<FilterAttributes> = ({ filterStudyGroupMemberForm, onReset, onSearch, loading }) => {
    const { t } = useTranslation(['study-group', 'staff', 'common']);
    const criteriaSelected = filterStudyGroupMemberForm.getFieldsValue();
    const criteriaCount: number = Object.values(criteriaSelected).reduce((count: number, val) => count + (val ? 1 : 0), 0);
    const [isModalOpen, setIsModalOpen] = useState(false);

    const breakPoint = {
        xs: 24,
        sm: 24,
        md: 12,
        lg: 12,
    };

    const onResetHandler = () => {
        onReset();
        setIsModalOpen(false);
    };

    const onSearchHandler = () => {
        onSearch();
        setIsModalOpen(false);
    };

    return (
        <div>
            <Button onClick={() => setIsModalOpen(true)} icon={<FilterOutlined />}>
                {criteriaCount > 0 && `(${criteriaCount})`} {t('common:filter')}
            </Button>
            <Modal title={t('common:filter')} onCancel={onResetHandler} open={isModalOpen} footer={null} width={650}>
                <Form form={filterStudyGroupMemberForm} layout="vertical" name="filter_form" className="mt-6" size="large">
                    <Row gutter={[16, 0]}>
                        {/* Name */}
                        <Col {...breakPoint}>
                            <Form.Item initialValue="" name="name" label={t('member-name/preferred-name')} labelCol={{ flex: '35px' }}>
                                <Input placeholder={t('member-name/preferred-name')} />
                            </Form.Item>
                        </Col>
                        {/* Phone Number */}
                        {/* <Col {...breakPoint}>
                            <Form.Item initialValue="" name="phoneNumber" label={t('phone-number')} labelCol={{ flex: '35px' }}>
                                <Input placeholder={t('phone-number')} />
                            </Form.Item>
                        </Col> */}
                    </Row>
                    <div className="flex justify-between mt-3 gap-x-3">
                        <Button onClick={onResetHandler} block loading={loading}>
                            {t('common:reset')}
                        </Button>
                        <Button type="primary" onClick={onSearchHandler} block loading={loading}>
                            {t('common:apply-filter')}
                            <SearchOutlined />
                        </Button>
                    </div>
                </Form>
            </Modal>
        </div>
    );
};

export default FilterDrawer;
