import { currencyFormatter, currencyParser } from '@/utils';
import { Col, Form, InputNumber, Row } from 'antd';
import { useTranslation } from 'next-i18next';

const BookTokenPriceForm: React.FC = () => {
    const { t } = useTranslation(['site-setting', 'layout', 'common', 'messages']);

    return (
        <Row gutter={[16, 16]} className="mb-2">
            <Col span={24}>
                <Form.Item name="price" label={t('book-token-price')} rules={[{ required: true, message: t('messages:required') }]}>
                    <InputNumber min={0} prefix={'MYR'} style={{ width: '100%' }} formatter={currencyFormatter} parser={currencyParser} />
                </Form.Item>
            </Col>
        </Row>
    );
};

export default BookTokenPriceForm;
