import { useTranslation } from 'next-i18next';
import { Card, Descriptions, Modal } from 'antd';
import dayjs from 'dayjs';
import { useBirthdayContext } from '@/providers/BirthdayContext';

const BirthdayListModal: React.FC = () => {
    const { t } = useTranslation(['birthday', 'layout', 'common', 'messages']);
    const { calendar } = useBirthdayContext();
    const { date, birthdayListModalOpen, setBirthdayListModalOpen, birthdayListQuery } = calendar;

    const onCloseHandler = () => {
        setBirthdayListModalOpen(false);
    };

    const data = birthdayListQuery.data ?? [];

    const filteredData = data.filter((birthday) => {
        const birthdayDate = dayjs.tz(birthday.dateOfBirth);

        // Check if the day and month of the birthday's dateOfBirth match the specified date
        return birthdayDate.date() === date.date() && birthdayDate.month() === date.month();
    });

    return (
        <Modal title={date.format('DD MMM YYYY')} open={birthdayListModalOpen} onCancel={onCloseHandler} width={700} footer={null}>
            {filteredData.map((birthday) => {
                return (
                    <Card className="mb-5" key={birthday.id}>
                        <Descriptions column={1} bordered size="small" labelStyle={{ fontWeight: '500', width: '150px', textAlign: 'right' }}>
                            <Descriptions.Item label={t('name')}>{birthday.fullName}</Descriptions.Item>
                            <Descriptions.Item label={t('address')}>{birthday.address}</Descriptions.Item>
                            <Descriptions.Item label={t('phone-number')}>{birthday.phoneNumber}</Descriptions.Item>
                        </Descriptions>
                    </Card>
                );
            })}
        </Modal>
    );
};

export default BirthdayListModal;
