import { CloudDownloadOutlined } from '@ant-design/icons';
import { Button } from 'antd';
import { useTranslation } from 'next-i18next';
import ExcelJS from 'exceljs';

// PDF
interface ExportDataProps {
    fileName: string;
    getExportData: () => Promise<{ data: any }>;
}

const ExportData: React.FC<ExportDataProps> = ({ fileName, getExportData }) => {
    const { t } = useTranslation(['birthday', 'layout', 'common', 'messages']);

    const workbook = new ExcelJS.Workbook();
    const worksheet = workbook.addWorksheet('Study Group Task Comments');

    // Columns
    worksheet.columns = [
        { header: 'Full Name', key: 'fullName', width: 20 },
        { header: 'Preferred Name', key: 'preferredName', width: 20 },
        { header: 'Address', key: 'address', width: 100 },
        { header: 'Phone Number', key: 'phoneNumber', width: 20 },
    ];

    // Add Row Style
    worksheet.getRow(1).font = { bold: true };
    worksheet.getRow(1).alignment = { horizontal: 'center' };
    worksheet.getRow(1).fill = {
        type: 'pattern',
        pattern: 'solid',
        fgColor: { argb: 'FFA9A9A9' },
    };

    const generateExcelHandler = async (data: any) => {
        data?.map((birthday: any) => {
            worksheet.addRow({
                fullName: birthday.fullName,
                preferredName: birthday.preferredName,
                address: birthday.address,
                phoneNumber: `;${birthday.phoneNumber}`,
            });
        });

        // Generate the Excel file
        await workbook.xlsx.writeBuffer().then((buffer: any) => {
            const blob = new Blob([buffer], { type: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet' });
            const link = document.createElement('a');
            const url = URL.createObjectURL(blob);
            link.href = url;
            link.setAttribute('download', fileName);
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        });
    };

    const exportToCsvHandler = () => {
        getExportData().then((res) => {
            generateExcelHandler(res.data);
        });
    };

    return (
        <Button type="primary" icon={<CloudDownloadOutlined />} onClick={exportToCsvHandler}>
            {t('export-csv')}
        </Button>
    );
};

export default ExportData;
