import { Book, MediaResponse, Member } from '.';
import { Package } from './package';

export enum BookTokenSubscriptionStatus {
    PENDING = 'PENDING',
    PAID = 'PAID',
    UNPAID = 'UNPAID',
    REJECTED = 'REJECTED',
}

export interface BookTokenSubscription {
    id: string;
    memberId: string;
    displayId: string;
    price: number;
    paymentDate: string;
    numberOfBookTokens: number;
    quantity: number;
    paymentStatus: BookTokenSubscriptionStatus;
    reason?: string;
    expiredAt?: Date;
    createdAt: string;
    bookTokenSubscriptionMedias: {
        media: MediaResponse;
    }[];
    member: Pick<Member, 'id' | 'fullName' | 'address' | 'phoneNumber'>;
    package: Package;
}

export interface BookTokenSubscriptionMedia {
    bookTokenSubscriptionId: string;
    mediaId: string;
    media: MediaResponse;
    createdAt: string;
    updatedAt: string;
}

export interface RequestBookTokenPayload {
    selectedPackage: string;
    unitPrice: number;
    quantity: number;
    totalAmount: number;
}

export type BookTokenSubscriptionList = Pick<
    BookTokenSubscription,
    | 'id'
    | 'paymentStatus'
    | 'reason'
    | 'price'
    | 'quantity'
    | 'numberOfBookTokens'
    | 'displayId'
    | 'expiredAt'
    | 'member'
    | 'package'
    | 'paymentDate'
    | 'bookTokenSubscriptionMedias'
>;

export type UploadProofOfPaymentPayload = Pick<BookTokenSubscription, 'paymentDate'> & { medias: { mediaId: string }[] };
