import axiosInstance from '@/configs/service';
import { BookQuery, BookTokenPrice, PaginationResponse, StudyBookRequest } from '@/types';
import { Package } from '@/types/package';

export const getBookRequestListByPagination = (query: BookQuery) => {
    return axiosInstance.get<PaginationResponse<StudyBookRequest>>('/member/book/request', {
        params: query,
    });
};

export const getPackageList = () => {
    return axiosInstance.get<Package[]>('/member/data/package');
};

export const getSupport = () => {
    return axiosInstance.get('/member/data/support');
};

export const getNotice = () => {
    return axiosInstance.get<{ jsonValue: JSON[] }[]>('/member/data/notice');
};

export const getUncommentedTasks = () => {
    return axiosInstance.get('/member/data/uncommented-tasks');
}
