import axiosInstance from '@/configs/service';
import { PaginationParams, PaginationResponse, SortOrder } from '@/types';
import { BookQuery, Book } from '@/types';

export const bookKeys = {
    all: ['book'],
    add: ['book', 'add'],
    id: (id: string) => [...bookKeys.all, id],
    pagination: (pagination: PaginationParams = { page: 1, pageSize: 10, sortField: 'createdAt', sortOrder: SortOrder.DESC }) => [
        ...bookKeys.all,
        'pagination',
        pagination,
    ],
};

export const getBookListByPagination = (query: BookQuery) => {
    return axiosInstance.get<PaginationResponse<Book>>('/member/book', {
        params: query,
    });
};

export const getBookById = (bookId: string) => {
    return axiosInstance.get<Book>(`/member/book/${bookId}`);
};

export const updateBookRequestStatus = (bookId: string) => {
    return axiosInstance.put<Book>(`/member/book/${bookId}/request`);
};

export const cancelBookRequest = (bookId: string, requestId: string) => {
    return axiosInstance.put(`/member/book/${bookId}/request/${requestId}/cancel-request`);
};
