import axiosInstance from "@/configs/service";
import { LoginParams, Member, VerificationParams } from "@/types";

export const login = (body: LoginParams) => {
    return axiosInstance.post<string>("/member/auth/login", body);
};

export const logout = () => {
    return axiosInstance.post<string>("/member/auth/logout");
};

export const authenticationMember = (body: {
    token: string;
}) => {
    return axiosInstance.post<Member>(
        "/member/auth/authenticate",
        body
    );
};

export const forgotPassword = (email: string) => {
    return axiosInstance.post("/member/auth/forgot-password", {
        email,
    });
};

export const resendVerificationEmail = (email: string) => {
    return axiosInstance.post(
        `/member/auth/resend-verification-email`,
        {
            email,
        }
    );
};

export const checkVerifyToken = (memberId: string, token: string) => {
    return axiosInstance.get<Member>(
        `/member/auth/tokenVerifier/${memberId}/${token}`
    );
};

export const verifyMember = (
    memberId: string,
    token: string,
    body: VerificationParams
) => {
    return axiosInstance.post<Member>(
        `/member/auth/verify/${memberId}/${token}`,
        body
    );
};

export const checkResetToken = (memberId: string, token: string) => {
    return axiosInstance.get<Pick<Member, "id" | "email">>(
        `/member/auth/verify-reset-token/${memberId}/${token}`
    );
};

export const resetPassword = (
    memberId: string,
    token: string,
    password: string
) => {
    return axiosInstance.post(
        `/member/auth/reset-password/${memberId}/${token}`,
        {
            password,
        }
    );
};
