import { useState } from 'react';
import { useRouter } from 'next/router';
import { Menu as AntMenu } from 'antd';
import { useTranslation } from 'next-i18next';
import { BookOutlined, FileSearchOutlined, PieChartOutlined } from '@ant-design/icons';
import { CgProfile } from 'react-icons/cg';
import { HiOutlineUserGroup } from 'react-icons/hi';
import { PiCoinVerticalLight } from 'react-icons/pi';

interface MenuProps {
    activeMenu: string[];
    activeDropdown: string[];
}

export const Menu: React.FC<MenuProps> = ({ activeMenu, activeDropdown }) => {
    const { t } = useTranslation(['layout']);
    const router = useRouter();
    const [selectedKeys, setSelectedKeys] = useState<string[]>(activeMenu);
    const [openKeys, setOpenKeys] = useState<string[]>(activeDropdown);

    const onSelectMenuHandler = (menu: string, path: string) => {
        setSelectedKeys([menu]);
        router.push(path);
    };

    const menuItems = [
        {
            key: 'dashboard',
            label: t('dashboard'),
            icon: <PieChartOutlined className="!text-base" />,
            onClick: () => onSelectMenuHandler('dashboard', '/dashboard'),
        },
        {
            key: 'book-token',
            label: t('book-token'),
            icon: <PiCoinVerticalLight className="!text-base" />,
            onClick: () => onSelectMenuHandler('book-token', '/book-token'),
        },
        {
            key: 'book-order',
            label: t('order-book'),
            icon: <BookOutlined className="!text-base" />,
            onClick: () => onSelectMenuHandler('book-order', '/book-order'),
        },
        {
            key: 'book-study-group-request',
            label: t('request-join-study-group'),
            icon: <BookOutlined className="!text-base" />,
            onClick: () => onSelectMenuHandler('book-study-group-request', '/book-study-group-request'),
        },
        {
            key: 'study-group',
            label: t('study-group'),
            icon: <HiOutlineUserGroup className="!text-base" />,
            onClick: () => onSelectMenuHandler('study-group', '/study-group'),
        },
        {
            key: 'study-group-request',
            label: t('study-group-request'),
            icon: <FileSearchOutlined className="!text-base" />,
            onClick: () => onSelectMenuHandler('study-group-request', '/study-group-request'),
        },
        {
            key: 'book-order-history',
            label: t('book-order-history'),
            icon: <FileSearchOutlined className="!text-base" />,
            onClick: () => onSelectMenuHandler('book-order-history', '/book-order-history'),
        },
        {
            key: 'settings',
            label: t('menu.settings'),
            type: 'group',
        },
        {
            key: 'my-profile',
            label: t('my-profile'),
            icon: <CgProfile className="!text-base" />,
            onClick: () => onSelectMenuHandler('my-profile', '/my-profile'),
        },
    ];

    return <AntMenu theme="light" mode="inline" defaultOpenKeys={openKeys} defaultSelectedKeys={selectedKeys} items={menuItems} />;
};
