import { Readable } from 'stream';

export enum EMAIL_TEMPLATES {
    STAFF_VERIFICATION = 'staff-verification',
    MEMBER_VERIFICATION = 'member-verification',
    STAFF_RESET_PASSWORD = 'staff-reset-password',
    MEMBER_RESET_PASSWORD = 'member-reset-password',
    TASK_ONGOING = 'task-ongoing',
    BIRTHDAY = 'birthday',
    REMINDER = 'reminder',
}

export interface Attachment {
    filename: string;
    content: string | Buffer | Readable;
}

export interface SendEmailConfig {
    to: string | string[];
    subject: string;
    template: string;
    context?: Record<string, any>;
    attachments?: Attachment[];
}

export interface StaffVerificationContext {
    name: string;
    staffId: string;
    token: string;
}

export interface MemberVerificationContext {
    name: string;
    memberId: string;
    token: string;
}

export interface StaffResetPasswordContext {
    name: string;
    staffId: string;
    resetToken: string;
}

export interface MemberResetPasswordContext {
    name: string;
    memberId: string;
    resetToken: string;
}

export interface TaskOngoingContext {
    name: string;
    task: string;
}

export interface BirthdayContext {
    name: string;
}

export interface ReminderContext {
    name: string;
    studyGroup: string;
    studyGroupLink: string;
}
