import { StudyGroupStatus } from '@prisma/client';
import { Pagination } from 'src/types';

// Study Group
export interface StudyGroupFilterParams extends Pagination {
    name: string;
    bookName: string;
    status: StudyGroupStatus;
    startDate: string;
    endDate: string;
    createdAt: string[];
    memberId: string;
}

export interface StudyGroupParams {
    studyGroupId: string;
}

export interface CreateStudyGroupDto {
    name: string;
    bookId: string;
    groupPeriod: string[];
}

export interface CreateStudyGroupMemberParams {
    studyGroupId: string;
    memberId: string;
}

export interface UpdateStudyGroupDto {
    name: string;
    groupPeriod: string[];
    description: string;
}

export interface GetStudyGroupMemberDto {
    name: string;
    phoneNumber: string;
}

export interface DeleteStudyGroupMemberDto {
    studyGroupId: string;
    memberId: string;
}

// Study Group Task
export interface StudyGroupTaskParams {
    studyGroupTaskId: string;
}

export interface UpdateDescriptionDto {
    description: string;
}

// Comment
export interface StudyGroupTaskCommentFilterDto {
    name: string;
}

export interface StudyGroupTaskCommentParams {
    studyGroupTaskCommentId: string;
}

// Old
export interface DeleteStudyGroupDto {
    groupId: string;
}

export interface CreateStudyGroupTaskDto {
    taskPeriod: string[];
}

export interface StudyGroupSubTaskParams {
    studyGroupSubTaskId: string;
}

export interface StudyGroupSubTaskCommentParams {
    commentId: string;
}

export interface UpdateTaskPeriodDto {
    taskPeriod: string[];
}

export interface ActivateTaskParams {
    studyGroupId: string;
    studyGroupTaskId: string;
}

export interface ExportStudyGroupMembers {
    name: string;
}

interface UpdateReplyDto {
    reply: string;
    commentId: string;
}

export type UpdateReply = UpdateReplyDto;
