import { BookTokenSubscriptionStatus } from '@prisma/client';
import * as Joi from 'joi';
import { paginationSchema } from 'src/utils/validators/pagination.schema';

export const bookTokenIdSchema = Joi.object({
    bookTokenId: Joi.string().required(),
});

export const bookTokenQuerySchema = Joi.object({
    refNo: Joi.string().allow('', null),
    memberName: Joi.string().allow('', null),
    packageName: Joi.string().allow('', null),
    status: Joi.string().allow(null, ''),
    paymentDate: Joi.array().items(Joi.string().required()).allow(null, ''),
    createdAt: Joi.array().items(Joi.string().required()).allow(null, ''),
}).concat(paginationSchema);

export const bookTokenParamsSchema = Joi.object({
    refNo: Joi.string().allow('', null),
    memberName: Joi.string().allow('', null),
    packageName: Joi.string().allow('', null),
    status: Joi.string().allow(null, ''),
    paymentDate: Joi.array().items(Joi.string().required()).allow(null, ''),
    createdAt: Joi.array().items(Joi.string().required()).allow(null, ''),
});

export const updateBookTokenSubscriptionByIdSchema = Joi.object({
    package: Joi.string().required(),
    expiredAt: Joi.date().allow('', null),
    paymentStatus: Joi.valid(
        BookTokenSubscriptionStatus.PAID,
        BookTokenSubscriptionStatus.UNPAID,
        BookTokenSubscriptionStatus.PENDING,
        BookTokenSubscriptionStatus.REJECTED,
    ).required(),
    reason: Joi.string().allow('', null),
    quantity: Joi.number().required(),
    uploadFile: Joi.array()
        .items(Joi.object({ mediaId: Joi.string().required() }).required())
        .required(),
});
