import { BookOrderStatus } from '@prisma/client';
import { Pagination } from 'src/types';

export interface BookOrderQuery extends Pagination {
    bookName: string;
    memberName: string;
    status: BookOrderStatus;
}

export interface CreateBookOrderDto {
    bookId: string;
    memberId: string;
    quantity: number;
}

export interface UpdateBookOrderDto {
    quantity: number;
    bookPrice: number;
    status: BookOrderStatus;
    media: { mediaId: string }[];
}
