import * as Joi from 'joi';
import { permissions } from 'src/data/role';

export const authenticationSchema = Joi.object({
    token: Joi.string().required(),
    permission: Joi.valid(...permissions)
        .optional()
        .allow(null, ''),
});

export const loginSchema = Joi.object({
    email: Joi.string().trim().lowercase().required(),
    password: Joi.string().required(),
});
