import { Controller, Get } from '@nestjs/common';
import { Authenticator, Member } from 'src/auth/auth.decorator';
import { MemberInRequest, User } from 'src/types';
import { MemberDataService } from './data.service';

@Controller()
export class MemberDataController {
    constructor(private readonly memberDataService: MemberDataService) {}

    @Authenticator(User.MEMBER)
    @Get('package')
    async getPackageList() {
        const response = this.memberDataService.getPackageList();

        return response;
    }

    @Get('support')
    async getSupportList() {
        const response = this.memberDataService.getSupport();

        return response;
    }

    @Get('notice')
    async getNotices() {
        const response = await this.memberDataService.getNotice();

        return response;
    }

    @Authenticator(User.MEMBER)
    @Get('uncommented-tasks')
    async getUncommentedTasks(@Member() member: MemberInRequest) {
        const response = await this.memberDataService.getUncommentedTasks(member.id);

        return response;
    }
}
