import { ExecutionContext, SetMetadata, createParamDecorator } from '@nestjs/common';
import { PERMISSION, User } from 'src/types';

export const Authenticator = (userType: User) => {
    return SetMetadata('authenticator', userType);
};

export const Authorizer = (permission: PERMISSION) => {
    return SetMetadata('authorizer', permission);
};

export const Staff = createParamDecorator((data: unknown, context: ExecutionContext) => {
    const request = context.switchToHttp().getRequest();
    return request.staff;
});

export const Member = createParamDecorator((data: unknown, context: ExecutionContext) => {
    const request = context.switchToHttp().getRequest();
    return request.member;
});
