import { Controller, Get, Query } from '@nestjs/common';
import { ActivityLogService } from './activity-log.service';

@Controller()
export class ActivityLogController {
    constructor(private activityLogService: ActivityLogService) {}

    @Get('log')
    async getActivityLog(@Query() query: ActivityLoggerQuery) {
        const { targetId, page, cursor } = query;

        const activityLogResponse = await this.activityLogService.getActivityLog(targetId, parseInt(page), !cursor ? null : (cursor as string));

        return {
            nextCursor: activityLogResponse.nextCursor,
            data: activityLogResponse.rows,
            count: activityLogResponse.count,
        };
    }
}
