import { TokenType } from '.';
import { PaginationParams } from './pagination';
// TODO: Add on based on client requirements
import { Role } from './role';

export enum StaffStatus {
    ACTIVE = 'ACTIVE',
    INACTIVE = 'INACTIVE',
}

interface StaffToken {
    staffId: string;
    type: TokenType;
    token: string;
    expiredAt: string;
    createdAt: string;
    updatedAt: string;
    usedAt?: string;
}
export interface Staff {
    id: string;
    fullName: string;
    email: string;
    password: string;
    status: StaffStatus;
    phoneNumber: string;
    roleId: string;
    role: Role;
    tokens: StaffToken[];
    lastActive: string;
    createdAt: string;
    updatedAt: string;
}

// TODO: Add on based on filter options
export interface StaffQuery extends PaginationParams {}

export interface CreateStaffParams {
    email: string;
    fullName: string;
    roleId: string;
    phoneNumber: string;
}

export interface UpdateStaffProfileParams {
    fullName: string;
}

export interface UpdateStaffEmailParams {
    email: string;
}

export interface UpdateStaffPhoneNumberParams {
    phoneNumber: string;
}

export interface UpdateStaffPasswordParams {
    password: string;
}

export interface UpdateStaffRoleParams {
    roleId: string;
}

export interface DeleteStaffParams {
    myStaffId: string;
}
