import { AxiosErrorResponse } from '.';

export interface LoginParams {
    email: string;
    password: string;
}

export interface VerificationParams {
    password: string;
}

export type AuthAxiosErrorResponse = AxiosErrorResponse<{
    unauthorized: boolean;
}>;

export type LoginErrorResponse = AxiosErrorResponse<{
    unverified?: boolean;
}>;

export type ForgotPasswordErrorResponse = AxiosErrorResponse<{
    unverified?: boolean;
}>;

export type ResendVerificationEmailErrorResponse = AxiosErrorResponse<{
    tooManyRequests?: boolean;
}>;

export type CheckVerifyTokenErrorResponse = AxiosErrorResponse<{
    verificationExpired?: boolean;
    email?: string;
}>;

export type VerifyTokenErrorResponse = AxiosErrorResponse<{
    verificationExpired?: boolean;
    email?: string;
}>;
