import axiosInstance from "@/configs/service";
import { CreateStaffParams, PaginationResponse, Staff, StaffQuery, UpdateStaffEmailParams, UpdateStaffPasswordParams, UpdateStaffPhoneNumberParams, UpdateStaffProfileParams, UpdateStaffRoleParams } from "@/types";

export const getStaffListByPagination = (query: StaffQuery) => {
    return axiosInstance.get<PaginationResponse<Staff>>('/staff/staff', {
        params: query,
    });
};

export const getStaffById = (staffId: string) => {
    return axiosInstance.get<Staff>(`/staff/staff/${staffId}`);
};

export const createStaff = (body: CreateStaffParams) => {
    return axiosInstance.post('/staff/staff', body);
};

export const updateStaffStatus = (staffId: string) => {
    return axiosInstance.put(`/staff/staff/${staffId}/status`);
};

export const updateStaffRole = (staffId: string, body: UpdateStaffRoleParams) => {
    return axiosInstance.put(`/staff/staff/${staffId}/role`, body);
};

export const updateStaffProfile = (staffId: string, body: UpdateStaffProfileParams) => {
    return axiosInstance.put(`/staff/staff/${staffId}/profile`, body);
};

export const updateStaffEmail = (staffId: string, body: UpdateStaffEmailParams) => {
    return axiosInstance.put(`/staff/staff/${staffId}/email`, body);
};

export const updateStaffPhoneNumber = (staffId: string, body: UpdateStaffPhoneNumberParams) => {
    return axiosInstance.put(`/staff/staff/${staffId}/phone-number`, body);
};

export const updateStaffPassword = (staffId: string, body: UpdateStaffPasswordParams) => {
    return axiosInstance.put(`/staff/staff/${staffId}/password`, body);
};

export const deleteStaff = (staffId: string) => {
    return axiosInstance.delete(`/staff/staff/${staffId}`);
};

export const resendVerificationEmail = (email: string) => {
    return axiosInstance.post<Pick<Staff, 'id' | 'email' | 'fullName'>>(`/staff/staff/resend-verification-email`, {
        email,
    });
};