import axiosInstance from '@/configs/service';
import {
    Member,
    MemberQuery,
    CreateMemberParams,
    PaginationResponse,
    UpdateMemberEmailParams,
    UpdateMemberPasswordParams,
    UpdateMemberPhoneNumberParams,
    UpdateMemberProfileParams,
    StudyGroup,
} from '@/types';

export const getMemberListByPagination = (query: MemberQuery) => {
    return axiosInstance.get<PaginationResponse<Member>>('/staff/member', {
        params: query,
    });
};

export const getExportMemberList = () => {
    return axiosInstance.get<Member[]>('/staff/member/export');
};

export const getMemberById = (id: string) => {
    return axiosInstance.get<Member>(`/staff/member/${id}`);
};

export const createMember = (body: CreateMemberParams) => {
    return axiosInstance.post<Member>('/staff/member', body);
};

export const updateMemberProfile = (id: string, body: UpdateMemberProfileParams) => {
    return axiosInstance.put<Member>(`/staff/member/${id}/profile`, body);
};

export const updateMemberEmail = (id: string, body: UpdateMemberEmailParams) => {
    return axiosInstance.put<Member>(`/staff/member/${id}/email`, body);
};

export const updateMemberPhoneNumber = (id: string, body: UpdateMemberPhoneNumberParams) => {
    return axiosInstance.put<Member>(`/staff/member/${id}/phone-number`, body);
};

export const updateMemberPassword = (id: string, body: UpdateMemberPasswordParams) => {
    return axiosInstance.put<Member>(`/staff/member/${id}/password`, body);
};

export const updateMemberStatus = (id: string) => {
    return axiosInstance.put<Member>(`/staff/member/${id}/status`);
};

export const deleteMember = (id: string) => {
    return axiosInstance.delete(`/staff/member/${id}`);
};

export const resendVerificationEmail = (email: string) => {
    return axiosInstance.post<Pick<Member, 'id' | 'email' | 'fullName'>>(`/staff/member/resend-verification-email`, {
        email,
    });
};
