import axiosInstance from '@/configs/service';
import { BookInvoice, BookQuotation, InvoiceBase, QuotationView } from '@/types';

export const getQuotationById = async () => {
    return axiosInstance.get<QuotationView>(`/public/bill/quotation/staff`);
};

export const getInvoiceByBookTokenSubscriptionId = async (bookTokenSubscriptionId: string) => {
    return axiosInstance.get<InvoiceBase>(`/public/bill/invoice/${bookTokenSubscriptionId}`);
};

export const getBookQuotationById = async () => {
    return axiosInstance.get<BookQuotation[]>(`/public/bill/quotation/staff/book-order`);
};

export const getInvoiceByBookOrderId = async (bookOrderId: string) => {
    return axiosInstance.get<BookInvoice>(`/public/bill/invoice/${bookOrderId}/book-order`);
};
