import axiosInstance from '@/configs/service';
import { LoginParams, Staff, VerificationParams } from '@/types';

export const login = (body: LoginParams) => {
    return axiosInstance.post<string>('/staff/auth/login', body);
};

export const logout = () => {
    return axiosInstance.post<string>('/staff/auth/logout');
};

export const authenticationStaff = (body: { token: string; permission: string }) => {
    return axiosInstance.post<Staff>('/staff/auth/authenticate', body);
};

export const forgotPassword = (email: string) => {
    return axiosInstance.post('/staff/auth/forgot-password', {
        email,
    });
};

export const resendVerificationEmail = (email: string) => {
    return axiosInstance.post(`/staff/auth/resend-verification-email`, {
        email,
    });
};

export const checkVerifyToken = (staffId: string, token: string) => {
    return axiosInstance.get<Staff>(`/staff/auth/tokenVerifier/${staffId}/${token}`);
};

export const verifyStaff = (staffId: string, token: string, body: VerificationParams) => {
    return axiosInstance.post<Staff>(`/staff/auth/verify/${staffId}/${token}`, body);
};

export const checkResetToken = (staffId: string, token: string) => {
    return axiosInstance.get<Pick<Staff, 'id' | 'email'>>(`/staff/auth/verify-reset-token/${staffId}/${token}`);
};

export const resetPassword = (staffId: string, token: string, password: string) => {
    return axiosInstance.post(`/staff/auth/reset-password/${staffId}/${token}`, {
        password,
    });
};
