import { Dispatch, PropsWithChildren, SetStateAction, createContext, useContext, useState } from 'react';
import { Staff } from '@/types';

export type StaffContextType = {
    staff: Staff | null;
    setStaff: Dispatch<SetStateAction<Staff | null>>;
};

const StaffContext = createContext<StaffContextType>({
    staff: null,
    setStaff: () => void 0,
});

type StaffProviderProps = PropsWithChildren;

const StaffProvider = ({ children }: StaffProviderProps) => {
    const [staff, setStaff] = useState<Staff | null>(null);

    return <StaffContext.Provider value={{ staff, setStaff }}>{children}</StaffContext.Provider>;
};

export default StaffProvider;

export const useStaffContext = () => {
    const context = useContext(StaffContext);

    if (!context) {
        throw new Error('useStaffContext must be used within a StaffProvider');
    }

    return context;
};
