import { WarningOutlined } from '@ant-design/icons';
import { NextPage } from 'next';
import Link from 'next/link';
import { useTranslation } from 'next-i18next';

const Unauthorized: NextPage = () => {
    const { t } = useTranslation('common');

    return (
        <div className="bg-[url('../../public/images/unauthorized.svg')] bg-[#D3D3D3] bg-cover bg-center min-h-screen flex justify-center items-center">
            <div className="w-[90%] md:w-[70%] lg:w-[60%] xl:w-[50%] h-auto flex justify-center">
                <div className="m-10 text-center text-[#313131]">
                    <h1 className="text-6xl md:text-[130px] lg:text-[160px] xl:text-[200px] tracking-wider mb-6 drop-shadow-lg">
                        <WarningOutlined className="mr-6" />
                        401
                    </h1>
                    <h1 className="text-sm md:text-lg tracking-wide mb-2 drop-shadow-lg">{t('you-are-not-unauthorized-to-access-this-page')}</h1>
                    <h1 className="text-xs md:text-sm tracking-wide">
                        {t('click')}{' '}
                        <span>
                            <Link href={'/dashboard'} className="!text-blue-500 hover:!text-blue-600 no-underline">
                                {t('here')}
                            </Link>
                        </span>{' '}
                        {t('to-return-to-the-dashboard')}
                    </h1>
                </div>
            </div>
        </div>
    );
};

export default Unauthorized;
