import { CloudDownloadOutlined } from '@ant-design/icons';
import { Button } from 'antd';
import { useTranslation } from 'next-i18next';
import ExcelJS from 'exceljs';

// PDF
interface ExportDataProps {
    fileName: string;
    data: any
}

const ExportPenaltyData: React.FC<ExportDataProps> = ({ fileName, data }) => {
    const { t } = useTranslation(['study-group', 'layout', 'common', 'messages']);

    const workbook = new ExcelJS.Workbook();
    const worksheet = workbook.addWorksheet('Study Group Task Comments');

    // Columns
    worksheet.columns = [
        { header: 'Full Name', key: 'fullName', width: 20 },
        { header: 'Phone Number', key: 'phoneNumber', width: 20 },
        { header: 'Penalty Amount', key: 'amount', width: 20 },
    ];

    // Add Row Style
    worksheet.getRow(1).font = { bold: true };
    worksheet.getRow(1).alignment = { horizontal: 'center' };
    worksheet.getRow(1).fill = {
        type: 'pattern',
        pattern: 'solid',
        fgColor: { argb: 'FFA9A9A9' },
    };

    const generateExcelHandler = async () => {
        data?.map((member: any) => {
            const extractMember = member.member;

            worksheet.addRow({
                fullName: extractMember.fullName,
                phoneNumber: `;${extractMember.phoneNumber}`,
                amount: `RM ${member.amount}`,
            });
        });

        // Generate the Excel file
        await workbook.xlsx.writeBuffer().then((buffer: any) => {
            const blob = new Blob([buffer], { type: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet' });
            const link = document.createElement('a');
            const url = URL.createObjectURL(blob);
            link.href = url;
            link.setAttribute('download', fileName);
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        });
    };

    const exportToCsvHandler = () => {
        generateExcelHandler();
    };

    return (
        <Button type="primary" icon={<CloudDownloadOutlined />} onClick={exportToCsvHandler}>
            {t('export-csv')}
        </Button>
    );
};

export default ExportPenaltyData;
