import { Card, Skeleton, Space } from 'antd';
import CountUp from 'react-countup';

interface StatisticCardProps {
    title: string;
    icon?: React.ReactNode;
    loading?: boolean;
    value: number
}

const StatisticCard: React.FC<StatisticCardProps> = ({ title, icon = null, loading = false, value = 0 }) => {
    const maxValue = 9999999999999;

    const displayValue = (value: number) => {
        return value > maxValue ? maxValue : value;
    };

    const Loading = () => {
        return (
            <Space direction="vertical" className='w-full'>
                <Skeleton.Input active={loading} block/>
                <div className='flex items-center gap-2'>
                    <Skeleton.Avatar active={loading} />
                    <Skeleton.Input active={loading} block />
                </div>
            </Space>
        );
    };

    return (
        <Card className="flex-1 group transition duration-300 ease-in-out hover:border-blue-300">
            {loading ? (
                <Loading />
            ) : (
                <>
                    <p className="text-lg text-gray-500 mb-2 transition duration-300 ease-in-out group-hover:text-blue-500">{title}</p>
                    <p className="text-3xl font-semibold text-black/80 flex items-center gap-2">
                        {icon} <CountUp end={displayValue(value)} />
                    </p>
                </>
            )}
        </Card>
    );
};

export default StatisticCard;
