import { useState } from 'react';
import { DatePicker, TimeRangePickerProps } from 'antd';
import dayjs, { Dayjs } from 'dayjs';

interface PresetCalendarRangeProps {
    value?: [Dayjs, Dayjs] | undefined;
    onChange?: (value: [Dayjs, Dayjs] | undefined) => void;
    onCalendarChange?: (value: [Dayjs, Dayjs]) => void;
}

const PresetCalendarRange: React.FC<PresetCalendarRangeProps> = ({ value, onChange, onCalendarChange }) => {
    const [date, setdate] = useState<[Dayjs, Dayjs] | undefined>(value);
    const [startDate, setStartDate] = useState<Dayjs>(value?.[0] ?? dayjs.tz());

    const onValueChange = (dates: [Dayjs, Dayjs]) => {
        setdate(dates);
        setStartDate(dates?.[0] ?? dayjs.tz());
        if (onChange) {
            onChange(dates);
        }
    };

    const rangePresets: TimeRangePickerProps['presets'] = [
        {
            label: '1 month',
            value: [startDate, startDate.add(1, 'month').subtract(1, 'day')],
        },
        {
            label: '3 months',
            value: [startDate, startDate.add(3, 'month').subtract(1, 'day')],
        },
        {
            label: '6 months',
            value: [startDate, startDate.add(6, 'month').subtract(1, 'day')],
        },
        {
            label: '1 year',
            value: [startDate, startDate.add(1, 'year').subtract(1, 'day')],
        },
        {
            label: '2 years',
            value: [startDate, startDate.add(2, 'year').subtract(1, 'day')],
        },
    ];

    return (
        <DatePicker.RangePicker
            className="w-full"
            presets={rangePresets}
            value={date}
            onChange={(value) => {
                onValueChange(value as [Dayjs, Dayjs]);
            }}
            onCalendarChange={(value) => {
                setStartDate(value?.[0] ?? dayjs.tz());
                if (onCalendarChange) {
                    onCalendarChange([startDate, value?.[1] ?? startDate]);
                }
            }}
            format="DD MMM YYYY"
        />
    );
};

export default PresetCalendarRange;
