/** @type {import('next').NextConfig} */
const { i18n } = require('./next-i18next.config');

const nextConfig = {
  reactStrictMode: true,
  i18n,
  async redirects() {
    return [
        {
            source: '/api/media/:key',
            destination:
                (process.env.NODE_ENV === 'production' ? process.env.NEXT_PUBLIC_PROD_API_URL : process.env.NEXT_PUBLIC_API_URL) +
                '/api/media/:key',
            permanent: false,
        },
    ];
},
}

module.exports = nextConfig
