import { UploadFile } from 'antd';

export interface Media {
    id: string;
    name: string;
    url: string;
}

export interface MediaFormValue {
    uid: string;
    name: string;
    url: string;
    status: 'done';
}

export type AntdUploadFormValue = MediaFormValue & UploadFile<MediaFormValue>;

export interface MediaResponse {
    id: string;
    key: string;
    name: string;
    type: string;
}

// The media type is used to send back to result of the upload to the server.
export interface MediaUploadResponse {
    mediaId: string;
}
