import { Book } from '@/types';
import { mediaUrlGenerator } from '@/utils';
import { Drawer } from 'antd';
import { useTranslation } from 'next-i18next';

interface ImageDrawerProps {
    open: boolean;
    setOpen: (open: boolean) => void;
    bookData: Book;
}

const ImageDrawer: React.FC<ImageDrawerProps> = ({ open, setOpen, bookData }) => {
    const { t } = useTranslation(['book', 'layout', 'common', 'messages']);

    return (
        <Drawer open={open} onClose={() => setOpen(false)} width={600}>
            <div className="text-2xl font-bold mb-4 ml-2">{t('images')}</div>
            <div>
                {bookData?.bookImages?.map((media) => {
                    return (
                        <img key={media.media.id} src={mediaUrlGenerator(media.media.key)} alt={media.media.name} className="h-[200px] w-auto m-2" />
                    );
                })}
            </div>
        </Drawer>
    );
};

export default ImageDrawer;
