import { BookOrderStatus } from '@/types/book-order';
import { Tag } from 'antd';
import { useTranslation } from 'next-i18next';

interface BookTokenStatusTagProps {
    status: BookOrderStatus;
}

const BookTokenStatusTag: React.FC<BookTokenStatusTagProps> = ({ status }) => {
    const { t } = useTranslation(['book-token', 'common', 'messages', 'layout']);

    switch (status) {
        case BookOrderStatus.PAID:
            return <Tag color="green">{t('paid')}</Tag>;
        case BookOrderStatus.UNPAID:
            return <Tag color="orange">{t('unpaid')}</Tag>;
        case BookOrderStatus.PENDING:
            return <Tag color="blue">{t('pending')}</Tag>;
    }
};

export default BookTokenStatusTag;
