import * as Joi from 'joi';

export const googleApiSchema = Joi.object({
    GMAIL_CLIENT_ID: Joi.string().required(),
    GMAIL_CLIENT_SECRET: Joi.string().required(),
    GMAIL_REFRESH_TOKEN: Joi.string().required(),
    GMAIL_USER: Joi.string().email().required(),
}).unknown(true);

export const smtpSchema = Joi.object({
    SMTP_HOST: Joi.string().required(),
    SMTP_PORT: Joi.number().required(),
    SMTP_SECURE: Joi.boolean().required(),
    SMTP_USER: Joi.string().email().required(),
    SMTP_PASSWORD: Joi.string().required(),
}).unknown(true);
