import { Pagination } from './pagination';
import { AccountStatus, Member } from '@prisma/client';
export interface MemberQuery extends Pagination {
    fullName: string;
    preferredName: string;
    email: string;
    phoneNumber: string;
    status: AccountStatus;
    dateOfBirth: string;
    createdAt: string[];
}

export interface MemberInRequest {
    id: string;
    email: string;
    fullName: string;
    status: string;
}

export interface MemberRegister
    extends Pick<Member, 'fullName' | 'preferredName' | 'email' | 'phoneNumber' | 'address' | 'dateOfBirth' | 'password'> {
    confirmPassword: string;
}
