import * as Joi from 'joi';
import { paginationSchema } from 'src/utils/validators/pagination.schema';

// Study Group
export const studyGroupByIdSchema = Joi.object({
    studyGroupId: Joi.string().required(),
});

export const studyGroupQuerySchema = Joi.object({
    name: Joi.string().allow(null, ''),
    bookName: Joi.string().allow(null, ''),
    status: Joi.string().allow(null, ''),
    startDate: Joi.string().allow(null, ''),
    endDate: Joi.string().allow(null, ''),
    createdAt: Joi.array().items(Joi.string().required()).allow(null, ''),
    memberId: Joi.string().uuid().allow(null, ''),
}).concat(paginationSchema);

export const studyGroupCreateSchema = Joi.object({
    name: Joi.string().required(),
    groupPeriod: Joi.array().items(Joi.string().required()).allow(null, ''),
    bookId: Joi.string().required(),
});

export const exportStudyGroupMemberSchema = Joi.object({
    name: Joi.string().allow(null, ''),
});

export const studyGroupMemberCreateSchema = Joi.object({
    studyGroupId: Joi.string().required(),
    memberId: Joi.string().required(),
});

export const studyGroupUpdateSchema = Joi.object({
    name: Joi.string().required(),
    groupPeriod: Joi.array().items(Joi.string().required()),
    description: Joi.string().allow(null, ''),
});

export const studyGroupDeleteSchema = Joi.object({
    studyGroupId: Joi.string().required(),
});

export const studyGroupMemberDeleteSchema = Joi.object({
    studyGroupId: Joi.string().required(),
    memberId: Joi.string().required(),
});

// Study Group Task
export const studyGroupTaskByIdSchema = Joi.object({
    studyGroupTaskId: Joi.string().required(),
});

export const studyGroupTaskDescriptionUpdateSchema = Joi.object({
    description: Joi.string().allow(null, ''),
});

// Study Group Member
export const studyGroupMemberByIdSchema = Joi.object({
    studyGroupMemberId: Joi.string().required(),
});

export const studyGroupMemberSchema = Joi.object({
    fullName: Joi.string().optional(),
    status: Joi.required(),
}).concat(paginationSchema);

export const studyGroupMembersSchema = Joi.object({
    name: Joi.string().allow(null, ''),
    phoneNumber: Joi.string().allow(null, ''),
}).concat(paginationSchema);

// Comment
export const studyGroupTaskCommentFilterSchema = Joi.object({
    name: Joi.string().allow(null, ''),
}).concat(paginationSchema);

export const updateReplySchema = Joi.object({
    reply: Joi.string().allow(null, ''),
    commentId: Joi.string().allow(null, ''),
});

// Old

export const studyGroupTaskCreateSchema = Joi.object({
    taskPeriod: Joi.array().items(Joi.string().required()).allow(null, ''),
});

export const studyGroupSubTaskByIdSchema = Joi.object({
    studyGroupSubTaskId: Joi.string().required(),
});

export const studyGroupSubTaskCommentParamsSchema = Joi.object({
    commentId: Joi.string().required(),
});

export const studyGroupTaskPeriodUpdateSchema = Joi.object({
    taskPeriod: Joi.array().items(Joi.string().required()).allow(null, ''),
});

export const activateTaskSchema = Joi.object({
    studyGroupId: Joi.string().required(),
    studyGroupTaskId: Joi.string().required(),
});
