import * as Joi from 'joi';
import { paginationSchema } from 'src/utils/validators/pagination.schema';

export const packageQuerySchema = Joi.object({
    name: Joi.string().allow('', null),
    status: Joi.string().allow(null, ''),
}).concat(paginationSchema);

export const addPackageSchema = Joi.object({
    name: Joi.string().required(),
    price: Joi.number().required(),
    status: Joi.string().required(),
    numberOfBookToken: Joi.number().required(),
    description: Joi.string().allow(null, ''),
});
