import * as Joi from 'joi';
import { permissions } from 'src/data/role';
import { paginationSchema } from 'src/utils/validators/pagination.schema';

const roleMapping = () => {
    // Assign role to object with true value
    const roleObject: Record<string, Joi.Schema> = {};
    permissions.forEach((role) => {
        roleObject[role] = Joi.boolean().required();
    });
    return roleObject;
};

export const rolesQuerySchema = Joi.object({
    name: Joi.string().allow(null, ''),
}).concat(paginationSchema);

export const createRoleSchema = Joi.object({
    name: Joi.string().required(),
    ...roleMapping(),
});

export const updateRoleSchema = Joi.object({
    name: Joi.string().required(),
    ...roleMapping(),
});
