import * as Joi from 'joi';
import { UploadType } from 'src/types';
import { paginationSchema } from 'src/utils/validators/pagination.schema';

export const bookIdParamSchema = Joi.object({
    bookId: Joi.string().uuid().required(),
});

export const addBookSchema = Joi.object({
    name: Joi.string().required(),
    description: Joi.string().allow('', null),
    price: Joi.number().required(),
    uploadType: Joi.string().valid(UploadType.FILE, UploadType.LINK, UploadType.NONE).optional(),
    link: Joi.when('uploadType', {
        is: 'link',
        then: Joi.link().required(),
    }),
    uploadFile: Joi.when('uploadType', {
        is: 'file',
        then: Joi.array().items(
            Joi.object({
                uid: Joi.string().required(),
                lastModified: Joi.number().required(),
                name: Joi.string().required(),
                size: Joi.number().required(),
                type: Joi.string().required(),
                percent: Joi.number().required(),
                originFileObj: Joi.object().required(),
                status: Joi.string().required(),
                response: Joi.object().required(),
            }),
        ),
    }),
    remarks: Joi.string().allow('', null),
    bookImages: Joi.array()
        .items(Joi.object({ mediaId: Joi.string().uuid() }))
        .required(),
});

export const updateBookSchema = Joi.object({
    availableForBuy: Joi.boolean().required(),
    remarks: Joi.string().allow('', null),
    bookImages: Joi.array()
        .items(Joi.object({ mediaId: Joi.string().uuid() }))
        .required(),
}).concat(addBookSchema);

export const bookQuerySchema = Joi.object({
    name: Joi.string().allow(null, ''),
    createdAt: Joi.array().items(Joi.string().required()).allow(null, ''),
}).concat(paginationSchema);
