import { Member, Prisma, PrismaClient, UploadType } from '@prisma/client';
import { faker } from '@faker-js/faker';
import * as argon from 'argon2';

const prisma = new PrismaClient();

const createDummyMembers = async (run = true) => {
    if (!run) return;
    let done = false;
    const password = await argon.hash('Qwerty#111');

    for (let i = 0; i < 15; i++) {
        const members: Pick<Member, 'fullName' | 'preferredName' | 'phoneNumber' | 'email' | 'address' | 'dateOfBirth' | 'password'> = {
            fullName: faker.person.fullName(),
            preferredName: faker.person.firstName(),
            phoneNumber: faker.phone.number('+###########'),
            email: faker.internet.email().toLowerCase(),
            address: faker.location.streetAddress(),
            dateOfBirth: faker.date.birthdate(),
            password,
        };

        const isMemberExist = await prisma.member.findFirst({ where: { email: members.email } });

        if (isMemberExist) continue;

        await prisma.member.create({
            data: {
                ...members,
            },
        });

        done = true;
    }

    return done;
};

const createBooks = async (run = true) => {
    if (!run) return;

    const books: Prisma.BookCreateManyInput[] = [...Array(10)].map(() => ({
        name: faker.music.songName(),
        description: faker.lorem.paragraph(),
        uploadType: UploadType.LINK,
        link: faker.internet.url(),
    }));

    await prisma.book.createMany({
        data: books,
    });
};

const initSiteSetting = async (run = true) => {
    if (!run) return;

    await prisma.metaData.upsert({
        where: {
            key: 'book-token-price',
        },
        update: {
            value: '10.2',
        },
        create: {
            key: 'book-token-price',
            value: '10.2',
        },
    });

    await prisma.metaData.upsert({
        where: {
            key: 'penalty-price',
        },
        update: {
            value: '10',
        },
        create: {
            key: 'penalty-price',
            value: '10',
        },
    });
};

const main = async () => {
    createDummyMembers(false);
    createBooks(false);
    initSiteSetting();
};

main()
    .catch((e) => {
        console.error(e);
        process.exit(1);
    })
    .finally(async () => {
        await prisma.$disconnect();
    });
