import { BookOrderStatus } from '@prisma/client';
import * as Joi from 'joi';
import { paginationSchema } from 'src/utils/validators/pagination.schema';

export const bookOrderQuerySchema = Joi.object({
    bookName: Joi.string().allow(null, ''),
}).concat(paginationSchema);

export const createBookOrderSchema = Joi.object({
    bookId: Joi.string().uuid().required(),
    quantity: Joi.number().required(),
});

export const updateBookOrderSchema = Joi.object({
    quantity: Joi.number().required(),
    status: Joi.string().valid(BookOrderStatus).required(),
    medias: Joi.array()
        .items(Joi.object({ mediaId: Joi.string().uuid().required() }))
        .required(),
});
