import { Controller, Get, Param, Res } from '@nestjs/common';
import * as contentDisposition from 'content-disposition';
import { Response } from 'express';
import { MediaService } from './media.service';

@Controller()
export class MediaController {
    constructor(private mediaService: MediaService) {}

    @Get('')
    async getMediaTest() {
        return 'Test';
    }

    @Get(':key')
    async getMedia(@Param('key') key: string, @Res() res: Response) {
        const mediaResponse = await this.mediaService.get(key);

        if (mediaResponse.attachment) {
            // Instead of res.attachment, you can set headers directly
            res.setHeader('Content-disposition', `inline; filename=${contentDisposition(mediaResponse.media.name)}`);
        } else {
            res.setHeader('Content-disposition', contentDisposition(mediaResponse.media.name));
        }
        res.setHeader('Content-type', mediaResponse.media.type);
        (mediaResponse.fileStream.Body as any).pipe(res);
    }

    @Get('download/:key')
    async downloadMedia(@Param('key') key: string, @Res() res: Response) {
        const mediaResponse = await this.mediaService.get(key);

        res.attachment(mediaResponse.media.name);
        // const stream = mediaResponse.fileStream!.Body!.transformToWebStream()
        (mediaResponse.fileStream.Body as any).pipe(res);
    }
}
