import { MailerModule } from '@nestjs-modules/mailer';
import { HandlebarsAdapter } from '@nestjs-modules/mailer/dist/adapters/handlebars.adapter';
import { Global, Module } from '@nestjs/common';
import { ConfigModule, ConfigService } from '@nestjs/config';
import { google } from 'googleapis';
import { join } from 'path';
import { PLATFORM_NAME } from 'src/config';
import { EmailService } from './email.service';

@Global()
@Module({
    imports: [
        MailerModule.forRootAsync({
            imports: [ConfigModule],
            useFactory: async (configService: ConfigService) => {
                const OAuth2 = google.auth.OAuth2;
                const Oauth2_client = new OAuth2(configService.get('GMAIL_CLIENT_ID'), configService.get('GMAIL_CLIENT_SECRET'));
                Oauth2_client.setCredentials({ refresh_token: configService.get('GMAIL_REFRESH_TOKEN') });
                return {
                    transport: {
                        service: 'gmail',
                        auth: {
                            type: 'OAuth2',
                            user: configService.get('GMAIL_USER'),
                            clientId: configService.get('GMAIL_CLIENT_ID'),
                            clientSecret: configService.get('GMAIL_CLIENT_SECRET'),
                            refreshToken: configService.get('GMAIL_REFRESH_TOKEN'),
                            accessToken: configService.get('GMAIL_ACCESS_TOKEN'),
                        },
                    },
                    defaults: {
                        from: `"${PLATFORM_NAME}" <${configService.get('GMAIL_USER')}>`,
                    },
                    template: {
                        dir: join(__dirname, 'templates', 'pages'),
                        adapter: new HandlebarsAdapter(),
                        options: {
                            strict: true,
                        },
                    },
                    options: {
                        partials: {
                            dir: join(__dirname, 'templates', 'layouts'),
                            options: {
                                strict: true,
                            },
                        },
                    },
                };
            },
            inject: [ConfigService],
        }),
    ],
    providers: [EmailService],
    exports: [EmailService],
})
export class EmailModule {}
